const popup = document.getElementById('popup');
const closeOptions = document.getElementById('close-options');

window.addEventListener('load', () => {
  const lastClosed = localStorage.getItem('popupClosedAt');

  if (!lastClosed || is24HoursPassed(lastClosed)) {
    setTimeout(() => {
      popup.classList.add('show');
      startShaking();
    }, 500);
  }
});

function showCloseOptions() {
  closeOptions.classList.remove('hidden');
}

function closeTemporarily() {
  hidePopup();
}

function closeFor24Hours() {
  localStorage.setItem('popupClosedAt', new Date().toISOString());
  hidePopup();
}

function closeCancel() {
  closeOptions.classList.add('hidden');
}


function hidePopup() {
  popup.classList.remove('show');
  setTimeout(() => popup.style.display = 'none', 800);
  clearInterval(shakeInterval);
}


function hidePopup() {
  popup.classList.remove('show');
  setTimeout(() => popup.style.display = 'none', 800);
  clearInterval(shakeInterval);
}

function is24HoursPassed(lastClosed) {
  const now = new Date();
  const closedTime = new Date(lastClosed);
  return now - closedTime >= 24 * 60 * 60 * 1000;
}


/* shake */
let shakeInterval;
function startShaking() {
  shakeInterval = setInterval(() => {
    popup.classList.add('shake');
    setTimeout(() => popup.classList.remove('shake'), 400);
  }, 10000);
}
