<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tastyc
 */

?>

<?php

//options
$blog_categories = get_field( 'blog_categories', 'option' );
$blog_excerpt = get_field( 'blog_excerpt', 'option' );

$layout = get_query_var( 'layout' );

//content
if ( $layout == 'column-1' ) {
	$image = get_the_post_thumbnail_url( get_the_ID(), 'tastyc_1920xAuto' );
} else {
	$image = get_the_post_thumbnail_url( get_the_ID(), 'tastyc_950xAuto' );
}

$categories_list = false;
if( $blog_categories ) {
	$categories_list = get_the_category( get_the_ID() );
}

$avatar_img = get_avatar_url( get_the_author_meta( 'ID' ) );

?>


<!-- blog card -->
<div class="tst-blog-card tst-mb-60">
	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	  <?php if ( has_post_thumbnail() ) : ?>
	  <a href="<?php echo esc_url( get_permalink() ); ?>" class="tst-cover-frame tst-anima-link">
	    <?php if ( $image ) : ?>
	    <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
	    <?php endif; ?>
	    <?php if ( $categories_list ) : ?>
		<div class="tst-card-badge">
			<?php 
			$total = count( $categories_list );
			$i = 0;
			foreach ( $categories_list as $category ) { $i++;
				if ( $total != $i ) {
					echo esc_html( $category->cat_name ) . ', ';
				} else {
					echo esc_html( $category->cat_name );
				}
			}
			?>
		</div>
		<?php endif; ?>
	  </a>
	  <?php endif; ?>
	  <div class="tst-descr">
	    <h5 class="tst-mb-15">
	    	<a href="<?php echo esc_url( get_permalink() ); ?>" class="tst-anima-link"><?php the_title(); ?></a>
	    </h5>
	    <?php if ( ! empty( get_the_title() ) ) : ?>
	    <div class="tst-date tst-date-m"><?php echo esc_html( get_the_date() ); ?></div>
	  	<?php else : ?>
	  	<div class="tst-date tst-date-m"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_date() ); ?></a></div>
	  	<?php endif; ?>
	    <?php if ( ! $blog_excerpt ) : ?>
	    <div class="tst-text"><?php the_excerpt(); ?></div>
	    <?php endif; ?>
	    <div class="tst-spacer-sm"></div>
	    <div class="tst-post-bottom">
	      <div class="tst-post-author">
	      	<?php if ( $avatar_img ) : ?>
	        <img src="<?php echo esc_url( $avatar_img ); ?>" alt="<?php echo esc_attr( get_the_author() ); ?>">
	    	<?php endif; ?>
	        <h6><?php the_author(); ?></h6>
	      </div>
	      <?php if ( ! empty( get_the_title() ) ) : ?>
	      <div class="tst-date"><?php echo esc_html( get_the_date() ); ?></div>
	  	  <?php else : ?>
	  	  <div class="tst-date"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_date() ); ?></a></div>
	  	  <?php endif; ?>
	    </div>
	  </div>
	</div>
	<!-- #post-<?php the_ID(); ?> -->
</div>
<!-- blog card end -->
