<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package tastyc
 */

get_header();
?>

<?php

$blog_featured_img = get_field( 'blog_featured_img', 'option' );
$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

?>

	<?php while ( have_posts() ) : the_post(); ?>
		<!-- container -->
		<div class="container">

		<!-- row -->
		<div class="row justify-content-center">

		  <!-- col -->
		  <div class="col-lg-12">
		    <h1 class="h2 tst-mb-30"><?php the_title(); ?></h1>
		    <div class="single-post-before-content">
		    	<?php tastyc_before_content(); ?>
		    </div>
		  </div>
		  <!-- col end -->

		  <?php if ( has_post_thumbnail() && ! $blog_featured_img ) : 
		  $image = get_the_post_thumbnail_url( get_the_ID(), 'tastyc_1920xAuto' ); ?>
		  <!-- col -->
		  <div class="col-lg-12">
			  <div class="tst-about-cover tst-video-cover tst-mb-60">
	              <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-image<?php endif; ?> href="<?php the_post_thumbnail_url( 'tastyc_1920xAuto' ); ?>">
	              	<img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>" class="tst-cover animateme" data-when="span" data-from="-1" data-to="2" data-easing="easeinout" data-scale="1.2" />
	              </a>
	          </div>
	      </div>
		  <!-- col end -->
		  <?php endif; ?>

		  <!-- col -->
		  <div class="col-lg-12">
		  	<?php get_template_part( 'template-parts/content', 'single' ); ?>
		  </div>
		  <!-- col end -->
		  
		  <?php tastyc_single_navigantion(); ?>

          <?php if ( comments_open() || get_comments_number() ) : 
			// If comments are open or we have at least one comment, load up the comment template.
			comments_template();
          endif; ?>

		</div>
        <!-- row end -->

        </div>
        <!-- container end -->

	<?php endwhile; ?>

<?php
get_footer();