<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Schedule Widget.
 *
 * @since 1.0
 */
class Tastyc_Schedule_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-schedule';
	}

	public function get_title() {
		return esc_html__( 'Schedule', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'h4' => __( 'H4', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button1',
			[
				'label'       => esc_html__( 'Button 1 (Text)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Text', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button1_link',
			[
				'label'       => esc_html__( 'Button 1 (URL)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'button1_reservation',
			[
				'label' => esc_html__( 'Button 1 (Reservation Popup)', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button2',
			[
				'label'       => esc_html__( 'Button 2 (Text)', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Text', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Button', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'button2_link',
			[
				'label'       => esc_html__( 'Button 2 (URL)', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Background Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'additional',
			[
				'label' => esc_html__( 'Addition Field?', 'tastyc-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'tastyc-plugin' ),
				'label_off' => __( 'No', 'tastyc-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'add_label',
			[
				'label'       => esc_html__( 'Label', 'tastyc-plugin' ),
				'label_block' 	  => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter label', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Label', 'tastyc-plugin' ),
				'condition'   => [
					'additional'	=> 'yes',
				],
			]
		);

		$this->add_control(
			'add_text',
			[
				'label'       => esc_html__( 'Text', 'tastyc-plugin' ),
				'label_block' 	  => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter text', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Text', 'tastyc-plugin' ),
				'condition'   => [
					'additional'	=> 'yes',
				],
			]
		);

		$this->add_control(
			'add_link',
			[
				'label'       => esc_html__( 'Link', 'tastyc-plugin' ),
				'label_block' 	  => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter link', 'tastyc-plugin' ),
				'default'     => '',
				'condition'   => [
					'additional'	=> 'yes',
				],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'label', [
				'label'       => esc_html__( 'Label', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter label', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Enter label', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'from_h', [
				'label'       => esc_html__( 'From (hours)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter hours', 'tastyc-plugin' ),
				'default'	=> esc_html__( '09', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'from_m', [
				'label'       => esc_html__( 'From (minutes)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter minutes', 'tastyc-plugin' ),
				'default'	=> esc_html__( '00', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'to_h', [
				'label'       => esc_html__( 'To (hours)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter hours', 'tastyc-plugin' ),
				'default'	=> esc_html__( '22', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'to_m', [
				'label'       => esc_html__( 'To (minutes)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter minutes', 'tastyc-plugin' ),
				'default'	=> esc_html__( '00', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-title--desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-title--desc',
			]
		);

		$this->add_control(
			'btn1_color',
			[
				'label'     => esc_html__( 'Button 1 Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'btn1_typography',
				'label'     => esc_html__( 'Button 1 Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-btn',
			]
		);

		$this->add_control(
			'btn2_color',
			[
				'label'     => esc_html__( 'Button 2 Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'btn2_typography',
				'label'     => esc_html__( 'Button 2 Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-text-frame .tst-label',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_label_color',
			[
				'label'     => esc_html__( 'Label Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-wh-frame .tst-label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_label_typography',
				'label'     => esc_html__( 'Label Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-wh-frame .tst-label',
			]
		);

		$this->add_control(
			'item_time_color',
			[
				'label'     => esc_html__( 'Time Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-wh-frame .h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_time_typography',
				'label'     => esc_html__( 'Time Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-wh-frame .h5',
			]
		);

		$this->add_control(
			'item_time_symb_color',
			[
				'label'     => esc_html__( 'Time Symb Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-banner-sm .tst-wh-frame .h5 .tst-color' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_time_symb_typography',
				'label'     => esc_html__( 'Time Symb Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-banner-sm .tst-wh-frame .h5 .tst-color',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );
		$this->add_inline_editing_attributes( 'button1', 'none' );
		$this->add_inline_editing_attributes( 'button2', 'none' );

		$this->add_inline_editing_attributes( 'add_label', 'basic' );
		$this->add_inline_editing_attributes( 'add_text', 'basic' );

		?>

		<!-- container -->
		<div class="container">

		<!-- banner sm -->
        <div class="tst-banner-sm">

          <?php if ( !empty($settings['image']['url']) ) : ?>
          <div class="tst-cover-frame">
          	<?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'tastyc_1920xAuto' ); $image_alt = get_post_meta( $settings['image']['id'], '_wp_attachment_image_alt', true); ?>
            <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="tst-cover">
            <?php endif; ?>
            <div class="tst-overlay"></div>
          </div>
          <?php endif; ?>

          <div class="row align-items-center">

            <div class="col-lg-8">

              <div class="tst-text-frame">
              	<?php if ( $settings['subtitle'] ) : ?>
                <div class="tst-suptitle tst-suptitle-mobile-center tst-white-2 tst-mb-15">
                	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
			          	<?php echo wp_kses_post( $settings['subtitle'] ); ?>
			        </span>
                </div>
                <?php endif; ?>
                <?php if ( $settings['title'] ) : ?>
                <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-white-2 tst-mb-30">
                	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
			          	<?php echo wp_kses_post( $settings['title'] ); ?>
			        </span>
                </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                <?php endif; ?>
                <?php if ( $settings['description'] ) : ?>
                <p class="tst-text tst-white-2 tst-mb-30">
                	<span <?php echo $this->get_render_attribute_string( 'description' ); ?>>
			          	<?php echo wp_kses_post( $settings['description'] ); ?>
			        </span>
                </p>
                <?php endif; ?>
                <?php if ( $settings['button1'] || $settings['button2'] ) : ?>
                <div class="tst-btn-mobile">
                  <?php if ( $settings['button1'] ) : ?>
                  <a<?php if ( $settings['button1_link'] ) : ?><?php if ( $settings['button1_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button1_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button1_link']['url'] ); ?>"<?php endif; ?> class="tst-btn<?php if ( $settings['button1_reservation'] == 'yes' ) : ?> tst-res-btn<?php endif; ?> tst-mr-30">
                  	<span <?php echo $this->get_render_attribute_string( 'button1' ); ?>>
			          	<?php echo wp_kses_post( $settings['button1'] ); ?>
			        </span>
                  </a>
                  <?php endif; ?>
                  <?php if ( $settings['button2'] ) : ?>
                  <a<?php if ( $settings['button2_link'] ) : ?><?php if ( $settings['button2_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button2_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button2_link']['url'] ); ?>"<?php endif; ?> class="tst-label tst-white-2">
                  	<span <?php echo $this->get_render_attribute_string( 'button2' ); ?>>
			          	<?php echo wp_kses_post( $settings['button2'] ); ?>
			        </span>
                  </a>
                  <?php endif; ?>
                </div>
                <?php endif; ?>
              </div>

            </div>
            <div class="col-lg-4">

              <div class="tst-wh-frame<?php if ( $settings['additional'] == 'yes' ) : ?> tst-wh-frame--add<?php endif; ?>">
              	<?php if ( $settings['additional'] == 'yes' ) : ?>
              	<div class="tst-wh-add tst-mb-30">
                  <?php if ( $settings['add_label'] ) : ?>
                  <div class="tst-label tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( 'add_label' ); ?>>
			          <?php echo wp_kses_post( $settings['add_label'] ); ?>
			        </span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $settings['add_text'] ) : ?>
                  <div class="h5">
                  	<?php if ( $settings['add_link'] ) : ?><a href="<?php echo esc_attr( $settings['add_link'] ); ?>" target="_blank"><?php endif; ?>
	                  <span <?php echo $this->get_render_attribute_string( 'add_text' ); ?>>
			        	<?php echo wp_kses_post( $settings['add_text'] ); ?>
			          </span>
			        <?php if ( $settings['add_link'] ) : ?></a><?php endif; ?>
              	  </div>
                  <?php endif; ?>
                </div>
                <?php endif; ?>

              	<?php if ( $settings['items'] ) : ?>
				<?php foreach ( $settings['items'] as $index => $item ) :
				$item_label = $this->get_repeater_setting_key( 'label', 'items', $index );
				$this->add_inline_editing_attributes( $item_label, 'basic' );

				$item_from_h = $this->get_repeater_setting_key( 'from_h', 'items', $index );
				$this->add_inline_editing_attributes( $item_from_h, 'basic' );

				$item_from_m = $this->get_repeater_setting_key( 'from_m', 'items', $index );
				$this->add_inline_editing_attributes( $item_from_m, 'basic' );

				$item_to_h = $this->get_repeater_setting_key( 'to_h', 'items', $index );
				$this->add_inline_editing_attributes( $item_to_h, 'basic' );

				$item_to_m = $this->get_repeater_setting_key( 'to_m', 'items', $index );
				$this->add_inline_editing_attributes( $item_to_m, 'basic' );
				?>
                <div class="tst-wh-time tst-mb-30">
                  <?php if ( $item['label'] ) : ?>
                  <div class="tst-label tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( $item_label ); ?>>
			          <?php echo wp_kses_post( $item['label'] ); ?>
			        </span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $item['from_h'] || $item['from_m'] ) : ?>
                  <div class="h5">
                  <span <?php echo $this->get_render_attribute_string( $item_from_h ); ?>>
		        	<?php echo wp_kses_post( $item['from_h'] ); ?>
		          </span>
                  <span class="tst-color">:</span>
              	  <span <?php echo $this->get_render_attribute_string( $item_from_m ); ?>>
		        	<?php echo wp_kses_post( $item['from_m'] ); ?>
		          </span>
              	  </div>
                  <?php endif; ?>
                  <?php if ( $item['to_h'] || $item['to_m'] ) : ?>
                  <div class="h5">
                  <span <?php echo $this->get_render_attribute_string( $item_to_h ); ?>>
		        	<?php echo wp_kses_post( $item['to_h'] ); ?>
		          </span>
                  <span class="tst-color">:</span>
              	  <span <?php echo $this->get_render_attribute_string( $item_to_m ); ?>>
		        	<?php echo wp_kses_post( $item['to_m'] ); ?>
		          </span>
                  </div>
                  <?php endif; ?>
                </div>
                <?php endforeach; ?>
          		<?php endif; ?>

              </div>

            </div>
          </div>

        </div>
        <!-- banner sm end -->

        <div class="tst-spacer"></div>

		</div>
		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Schedule_Widget() );
