<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Reservation Form Widget.
 *
 * @since 1.0
 */

class Tastyc_Reservation_Form_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-reservation-form';
	}

	public function get_title() {
		return esc_html__( 'Reservation Form', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'heading_tab',
			[
				'label' => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'h4' => __( 'H4', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_tab',
			[
				'label' => esc_html__( 'Form', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'reservation_type',
			[
				'label'       => esc_html__( 'Reservation Type', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'default' => 'cf7',
				'options' => [
					'cf7'  => __( 'Contact Form 7', 'tastyc-plugin' ),
					'opentable' => __( 'OpenTable Form', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'reservation_form',
			[
				'label' => esc_html__( 'Select CF7 Form', 'tastyc-plugin' ),
				'label_block' => true,
				'type' => Controls_Manager::SELECT,
				'default' => 1,
				'options' => $this->contact_form_list(),
				'condition' => [
					'reservation_type' => 'cf7',
				],
			]
		);

		$this->add_control(
			'opentable_id',
			[
				'label' => esc_html__( 'OpenTable ID', 'tastyc-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter OpenTable ID', 'tastyc-plugin' ),
				'default' => '412810',
				'condition' => [
					'reservation_type' => 'opentable',
				],
			]
		);

		$this->add_control(
			'opentable_layout',
			[
				'label'       => esc_html__( 'OpenTable Layout', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'default' => 'horizontal',
				'options' => [
					'horizontal'  => __( 'Horizontal', 'tastyc-plugin' ),
					'vertical' => __( 'Vertical', 'tastyc-plugin' ),
				],
				'condition' => [
					'reservation_type' => 'opentable',
				],
			]
		);

		$this->add_control(
			'opentable_lang',
			[
				'label'       => esc_html__( 'OpenTable Language', 'tastyc-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'default' => 'en-US',
				'options' => [
					'en-US'  => __( 'English-US', 'tastyc-plugin' ),
					'fr-CA' => __( 'Français-CA', 'tastyc-plugin' ),
					'de-DE' => __( 'Deutsch-DE', 'tastyc-plugin' ),
					'es-MX' => __( 'Español-MX', 'tastyc-plugin' ),
					'ja-JP' => __( '日本語-JP', 'tastyc-plugin' ),
					'nl-NL' => __( 'Nederlands-NL', 'tastyc-plugin' ),
					'it-IT' => __( 'Italiano-IT', 'tastyc-plugin' ),
				],
				'condition' => [
					'reservation_type' => 'opentable',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'heading_styling',
			[
				'label'     => esc_html__( 'Heading Styles', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'description_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_styling',
			[
				'label'     => esc_html__( 'Form Styles', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label'     => esc_html__( 'Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label'     => esc_html__( 'Button Background Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button_typography',
				'label'     => esc_html__( 'Button Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-btn',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render Contact Form List.
	 *
	 * @since 1.0
	 */
	protected function contact_form_list() {
		$cf7_posts = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

		$cf7_forms = array();

		if ( $cf7_posts ) {
			foreach ( $cf7_posts as $cf7_form ) {
				$cf7_forms[ $cf7_form->ID ] = $cf7_form->post_title;
			}
		} else {
			$cf7_forms[ esc_html__( 'No contact forms found', 'tastyc-plugin' ) ] = 0;
		}

		return $cf7_forms;
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );

		?>

		<!-- container -->
		<div class="container">

			<div class="row">

			  <?php if ( $settings['title'] || $settings['subtitle'] || $settings['description'] ) : ?>
              <div class="col-lg-12">
                <!-- title -->
                <div class="text-center">
                  <?php if ( $settings['subtitle'] ) : ?>
                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
			          	<?php echo wp_kses_post( $settings['subtitle'] ); ?>
			        </span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $settings['title'] ) : ?>
                  <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-mb-30">
                  	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
			          	<?php echo wp_kses_post( $settings['title'] ); ?>
			        </span>
                  </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                  <?php endif; ?>
                  <?php if ( $settings['description'] ) : ?>
                  <p class="tst-text tst-mb-60">
                  	<span <?php echo $this->get_render_attribute_string( 'description' ); ?>>
			          	<?php echo wp_kses_post( $settings['description'] ); ?>
			        </span>
                  </p>
                  <?php endif; ?>
                </div>
                <!-- title end -->
              </div>
          	  <?php endif; ?>

          	  <?php if ( $settings['reservation_type'] == 'cf7' ) : ?>
	          	  <?php if ( $settings['reservation_form'] ) : ?>
	              <div class="col-lg-12">
	              	<div class="text-center">
	                	<?php echo do_shortcode( '[contact-form-7 id="'. $settings['reservation_form'] .'"]' ); ?>
	                </div>
	              </div>
	              <?php endif; ?>
	          <?php else : ?>
	          	  <?php if ( $settings['opentable_id'] ) : ?>
	              <div class="col-lg-12">
	                <form method="get" class="tst-opentable-form" action="//www.opentable.com/restaurant-search.aspx" target="_blank">
						<div class="row">
						  <div class="col-12<?php if ( $settings['opentable_layout'] == 'horizontal' ) : ?> col-md-4<?php endif; ?>">
						    <select id="reservation_party" name="partySize">
								<option value="1">1 <?php echo esc_html__( 'Person', 'tastyc-plugin' ); ?></option>
								<option value="2" selected="selected">2 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="3">3 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="4">4 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="5">5 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="6">6 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="7">7 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="8">8 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="9">9 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="10">10 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="11">11 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="12">12 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="13">13 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="14">14 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="15">15 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="16">16 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="17">17 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="18">18 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="19">19 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="20">20 <?php echo esc_html__( 'People', 'tastyc-plugin' ); ?></option>
								<option value="21"><?php echo esc_html__( 'Larger party', 'tastyc-plugin' ); ?></option>
							</select>
						  </div>
						  <div class="col-12<?php if ( $settings['opentable_layout'] == 'horizontal' ) : ?> col-md-4<?php endif; ?>">
						    <div class="datepicker__container">
						      <input id="reservation_date" name="startDate" class="datepicker-here" type="text" value="" placeholder="<?php echo esc_attr__( 'Date', 'tastyc-plugin' ); ?>" autocomplete="off" readonly="readonly">
						    </div>
						  </div>
						  <div class="col-12<?php if ( $settings['opentable_layout'] == 'horizontal' ) : ?> col-md-4<?php endif; ?>">
						    <select id="reservation_time" name="ResTime">
								<?php
								//Time Loop
								$inc = 30 * 60;
								$start = ( strtotime( '8AM' ) ); // 6  AM
								$end = ( strtotime( '11:59PM' ) ); // 10 PM


								for ( $i = $start; $i <= $end; $i += $inc ) {
									// to the standart format
									$time      = date( 'g:i a', $i );
									$timeValue = date( 'g:ia', $i );
									$default   = "7:00pm";
									echo "<option value=\"$timeValue\" " . ( ( $timeValue == $default ) ? ' selected="selected" ' : "" ) . ">$time</option>" . PHP_EOL;
								}

								?>
							</select>
						  </div>
						</div>
						<div class="text-center">
							<button class="tst-btn" type="submit" name="button"><?php echo esc_html__( 'Reserve a table', 'tastyc-plugin' ); ?></button>
							<p class="tst-powered d-center tst-p-15-0"><?php echo wp_kses_post( '* Powered by <img src="' . home_url() . '/wp-content/themes/tastyc/assets/images/opentable.svg" alt="" />', 'tastyc-plugin' ); ?></p>
						</div>
						<input type="hidden" name="RestaurantID" class="RestaurantID" value="<?php echo esc_attr( $settings['opentable_id'] ); ?>">
						<input type="hidden" name="rid" class="rid" value="<?php echo esc_attr( $settings['opentable_id'] ); ?>">
						<input type="hidden" name="GeoID" class="GeoID" value="15">
						<input type="hidden" name="txtDateFormat" class="txtDateFormat" value="MM/dd/yyyy">
						<input type="hidden" name="RestaurantReferralID" class="RestaurantReferralID" value="<?php echo esc_attr( $settings['opentable_id'] ); ?>">
						<input type="hidden" name="lang" class="lang" value="<?php echo esc_attr( $settings['opentable_lang'] ); ?>">
					</form>
	              </div>
	              <?php else : ?>
		          <div class="col-lg-12">
			        <p><?php echo esc_html__( 'You haven\'t added OpenTable ID', 'tastyc-plugin' ); ?></p>
			      </div>
		          <?php endif; ?>
	          <?php endif; ?>

            </div>

        </div>

		<!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Reservation_Form_Widget() );
