<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Products Carousel Widget.
 *
 * @since 1.0
 */
class Tastyc_Products_Carousel_Custom_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-products-carousel-custom';
	}

	public function get_title() {
		return esc_html__( 'Products (Custom Carousel)', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'heading_tab',
			[
				'label' => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'tastyc-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'tastyc-plugin' ),
					'h2' => __( 'H2', 'tastyc-plugin' ),
					'h3' => __( 'H3', 'tastyc-plugin' ),
					'div' => __( 'DIV', 'tastyc-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter description', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Title', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Title', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Description', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Description', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'price_old', [
				'label'       => esc_html__( 'Price (old)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Price (old)', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Price (old)', 'tastyc-plugin' ),
			]
		);

		$repeater->add_control(
			'price', [
				'label'       => esc_html__( 'Price', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Price', 'tastyc-plugin' ),
				'default'	=> esc_html__( 'Price', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'tastyc-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();
        
        $this->start_controls_section(
			'buttons_tab',
			[
				'label' => esc_html__( 'Buttons', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'more_btn_txt',
			[
				'label'       => esc_html__( 'Button (title)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter button', 'tastyc-plugin' ),
				'default'     => esc_html__( 'All Products', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'more_btn_link',
			[
				'label'       => esc_html__( 'Button (link)', 'tastyc-plugin' ),
				'type'        => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-suptitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-suptitle',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-title--h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-title--h',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .row .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .row .tst-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'item_bg_color',
			[
				'label'     => esc_html__( 'Item BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item h5 a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_title_typography',
				'label'     => esc_html__( 'Title Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-item h5 a',
			]
		);

		$this->add_control(
			'item_desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item .tst-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_desc_typography',
				'label'     => esc_html__( 'Description Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-item .tst-text',
			]
		);

		$this->add_control(
			'item_price_color',
			[
				'label'     => esc_html__( 'Price Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item .tst-price' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_price_typography',
				'label'     => esc_html__( 'Price Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-item .tst-price',
			]
		);

		$this->add_control(
			'item_btn_color',
			[
				'label'     => esc_html__( 'Button Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item .tst-btn svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_btn_bgcolor',
			[
				'label'     => esc_html__( 'Button BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-menu-book-item .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_btn_typography',
				'label'     => esc_html__( 'Button Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-menu-book-item .tst-btn',
			]
		);

		$this->end_controls_section();
        
        $this->start_controls_section(
			'buttons_styling',
			[
				'label'     => esc_html__( 'Buttons', 'tastyc-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_more_color',
			[
				'label'     => esc_html__( 'Button More Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-slider-navigation .tst-btn svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_more_bgcolor',
			[
				'label'     => esc_html__( 'Button More BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-slider-navigation .tst-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button_more_typography',
				'label'     => esc_html__( 'Button More Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-slider-navigation .tst-btn',
			]
		);

		$this->add_control(
			'button_nav_color',
			[
				'label'     => esc_html__( 'Button Nav Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-slider-navigation .tst-nav .tst-slider-btn i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_nav_bgcolor',
			[
				'label'     => esc_html__( 'Button Nav BG Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-slider-navigation .tst-nav .tst-slider-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_nav_label_color',
			[
				'label'     => esc_html__( 'Button Nav Label Color', 'tastyc-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .tst-slider-navigation .tst-label' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button_nav_label_typography',
				'label'     => esc_html__( 'Button Nav Label Typography', 'tastyc-plugin' ),
				'selector' => '{{WRAPPER}} .tst-slider-navigation .tst-label',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'basic' );
        $this->add_inline_editing_attributes( 'more_btn_txt', 'none' );

		?>

		<!-- container -->
		<div class="container">

            <div class="row align-items-center">

              <?php if ( $settings['title'] || $settings['subtitle'] || $settings['description'] ) : ?>
              <div class="col-lg-12">

                <!-- title -->
                <div class="text-center">
                  <?php if ( $settings['subtitle'] ) : ?>
                  <div class="tst-suptitle tst-suptitle-center tst-mb-15">
                  	<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>><?php echo wp_kses_post( $settings['subtitle'] ); ?></span>
                  </div>
                  <?php endif; ?>
                  <?php if ( $settings['title'] ) : ?>
                  <<?php echo esc_attr( $settings['title_tag'] ); ?> class="tst-title--h tst-mb-30">
                  	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>><?php echo wp_kses_post( $settings['title'] ); ?></span>
                  </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                  <?php endif; ?>
                  <?php if ( $settings['description'] ) : ?>
                  <p class="tst-text">
                  	<span <?php echo $this->get_render_attribute_string( 'description' ); ?>><?php echo wp_kses_post( $settings['description'] ); ?></span>
                  </p>
                  <?php endif; ?>
                </div>
                <!-- title end-->

              </div>
          	  <?php endif; ?>

              <div class="col-lg-12">

                <!-- slider -->
				<?php if ( $settings['items'] ) : ?>
                <div class="swiper-container tst-slider">
                  <div class="swiper-wrapper">
					<?php foreach ( $settings['items'] as $index => $item ) :
						$item_name = $this->get_repeater_setting_key( 'title', 'items', $index );
						$this->add_inline_editing_attributes( $item_name, 'basic' );

						$item_description = $this->get_repeater_setting_key( 'description', 'items', $index );
						$this->add_inline_editing_attributes( $item_description, 'basic' );

						$item_price_old = $this->get_repeater_setting_key( 'price_old', 'items', $index );
						$this->add_inline_editing_attributes( $item_price_old, 'basic' );

						$item_price = $this->get_repeater_setting_key( 'price', 'items', $index );
						$this->add_inline_editing_attributes( $item_price, 'basic' );
					?>
                    <div class="swiper-slide">

                    <div class="tst-menu-book-item">
						<?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'kinsley_950xAuto' ); ?>
                        <a href="<?php echo esc_url( $image ); ?>" class="tst-item-cover-frame tst-cursor-zoom">
                          <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                          <span class="tst-overlay"></span>
                        </a>
                        <?php endif; ?>
                        <div class="tst-menu-book-descr">
							<div class="tst-menu-book-name">
								<?php if ( $item['title'] ) : ?>
								<h5 class="tst-mb-15">
									<a href="<?php echo esc_url( $item['image']['url'] ); ?>">
										<span <?php echo $this->get_render_attribute_string( $item_name ); ?>>
											<?php echo wp_kses_post( $item['title'] ); ?>
										</span>
									</a>
								</h5>
								<?php endif; ?>
								<?php if ( $item['description'] ) : ?>
								<div class="tst-text">
									<span <?php echo $this->get_render_attribute_string( $item_description ); ?>>
										<?php echo wp_kses_post( $item['description'] ); ?>
									</span>
								</div>
								<?php endif; ?>
								<div class="tst-spacer-sm"></div>
							</div>
							<div class="tst-menu-book-bottom">
								<div class="tst-menu-book-price">
									<?php if ( $item['price_old'] ) : ?>
									<del>
										<span class="tst-price tst-old-price">
											<bdi>
												<span <?php echo $this->get_render_attribute_string( $item_price_old ); ?>>
													<?php echo wp_kses_post( $item['price_old'] ); ?>
												</span>
											</bdi>
										</span>
									</del>
									<?php endif; ?>
									<?php if ( $item['price'] ) : ?>
									<div class="tst-price">
										<span <?php echo $this->get_render_attribute_string( $item_price ); ?>>
											<?php echo wp_kses_post( $item['price'] ); ?>
										</span>
									</div>
									<?php endif; ?>
								</div>
							</div>
                        </div>
                    </div>

                    </div>
                    <?php endforeach; ?>

                  </div>

                </div>
                <?php endif; ?>
                <!-- slider -->

              </div>

              <div class="col-lg-12">

                <!-- slider navigation -->
                <div class="tst-slider-navigation">
                  <?php if ( $settings['more_btn_txt'] ) : ?>
                  <a <?php if ( $settings['more_btn_link']['url'] ) : ?><?php if ( $settings['more_btn_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['more_btn_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['more_btn_link']['url'] ); ?>"<?php endif; ?> class="tst-btn">
                  	<span <?php echo $this->get_render_attribute_string( 'more_btn_txt' ); ?>>
                  		<?php echo wp_kses_post( $settings['more_btn_txt'] ); ?>
                  	</span>
                  </a>
              	  <?php endif; ?>
                  <div class="tst-slider-pagination tst-testi-pagination"></div>
                  <div class="tst-nav tst-right">
                    <div class="tst-label"><?php echo esc_html( 'Slider navigation', 'tastyc-plugin' ); ?></div>
                    <div class="tst-slider-btn tst-prev"><i class="fas fa-arrow-left"></i></div>
                    <div class="tst-slider-btn tst-next"><i class="fas fa-arrow-right"></i></div>
                  </div>
                </div>
                <!-- slider navigation end -->

              </div>

            </div>

        </div>
        <!-- container end -->

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Products_Carousel_Custom_Widget() );