<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tastyc Header Logo Widget.
 *
 * @since 1.0
 */
class Tastyc_Header_Logo_Widget extends Widget_Base {

	public function get_name() {
		return 'tastyc-header-logo';
	}

	public function get_title() {
		return esc_html__( 'Header Logo', 'tastyc-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'tastyc-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'tastyc-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_light',
			[
				'label' => esc_html__( 'Image (Light)', 'tastyc-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'alt',
			[
				'label'       => esc_html__( 'Alt', 'tastyc-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter ALT', 'tastyc-plugin' ),
				'default'     => esc_html__( 'Logo', 'tastyc-plugin' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Logo (URL link)', 'tastyc-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<div class="tst-logo-two">
			<a <?php if ( $settings['link'] ) : ?><?php if ( $settings['link']['is_external'] ) : ?>target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>"<?php endif; ?>>
				<?php if ( $settings['image'] ) : $image = wp_get_attachment_image_url( $settings['image']['id'], 'tastyc_900xAuto' ); ?>
				<img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $settings['alt'] ); ?>" class="logo-dark">
				<?php endif; ?>
				<?php if ( $settings['image_light'] ) : $image_light = wp_get_attachment_image_url( $settings['image_light']['id'], 'tastyc_900xAuto' ); ?>
				<img src="<?php echo esc_url( $image_light ); ?>" alt="<?php echo esc_attr( $settings['alt'] ); ?>" class="logo-lght">
				<?php endif; ?>
			</a>
		</div>

		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Tastyc_Header_Logo_Widget() );
